/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.hwmca.base.fmtmedia;

import com.ibm.hwmca.base.fmtmedia.FormatDisketteBean;
import com.ibm.hwmca.base.fmtmedia.FormatDvdCartridgeBean;
import com.ibm.hwmca.base.fmtmedia.FormatHighSpeedBean;
import com.ibm.hwmca.base.fmtmedia.FormatMediaConstants;
import com.ibm.hwmca.base.fmtmedia.FormatMediaErrorIds;
import com.ibm.hwmca.base.fmtmedia.MediaFormatBean;
import com.ibm.hwmca.base.settings.network.NetworkInfo;
import com.ibm.hwmca.base.util.BaseMessageText;
import com.ibm.hwmca.base.util.BaseMessageTitle;
import com.ibm.hwmca.fw.HException;
import com.ibm.hwmca.fw.log.FrameworkClassLogInfo;
import com.ibm.hwmca.fw.log.FrameworkLog;
import com.ibm.hwmca.fw.log.MicrocodeLogAttributes;
import com.ibm.hwmca.fw.mediasvc.MediaDevice;
import com.ibm.hwmca.fw.mediasvc.MediaDeviceException;
import com.ibm.hwmca.fw.mediasvc.MediaDeviceIdentifier;
import com.ibm.hwmca.fw.mediasvc.MediaDeviceLockException;
import com.ibm.hwmca.fw.mediasvc.MediaServices;
import com.ibm.hwmca.fw.mediasvc.MediaServicesUtil;
import com.ibm.hwmca.fw.mediasvc.MediaWriteProtectedException;
import com.ibm.hwmca.fw.mediasvc.NoMediaPresentException;
import com.ibm.hwmca.fw.tasklet.PanelTasklet;
import com.ibm.hwmca.fw.tasklet.PanelTaskletRequest;
import com.ibm.hwmca.fw.tasklet.PanelTaskletResponse;
import com.ibm.hwmca.fw.tasklet.TaskletException;
import com.ibm.hwmca.fw.util.LocalizableText;
import com.ibm.hwmca.fw.util.MessageText;
import com.ibm.hwmca.fw.util.Trace;
import java.io.File;

public class FormatMediaTasklet
extends PanelTasklet
implements FormatMediaErrorIds,
FormatMediaConstants {
    private static final String RES_BUNDLE_NAME = "com.ibm.hwmca.base.res.message";
    private static final String TRACE_MASKT = "XFMTSFTT";
    private static final String TRACE_MASKF = "XFMTSFTF";
    private static final String TRACE_MASKD = "XFMTSFTD";
    public static final String PANEL_TITLE = "DVD80007";
    public static final String BUSY_MSG1 = "DVD80008";
    private static final String AUIML_FILE_NAME = "com.ibm.hwmca.base.fmtmedia.res.FormatMediaRes";
    private static final String PANEL_NAME_INITIAL = "FormatMediaPanel";
    private static final String PANEL_NAME_DISKETTE = "FormatDiskettePanel";
    private static final String PANEL_NAME_DVD = "FormatDvdCartridgePanel";
    private static final String PANEL_NAME_HIGHSPEED = "FormatHighSpeedPanel";
    private static FrameworkClassLogInfo _logInfo = new FrameworkClassLogInfo(3, "FormatMedia");
    public static final int FILESYSTEM_UDF = 2;
    public static final int FILESYSTEM_ISO9660 = 3;
    public static final int FILESYSTEM_EXT2 = 4;
    public static final int FILESYSTEM_EXT3 = 5;
    public static final int FILESYSTEM_VFAT = 1;
    MediaDevice formatDevice = null;
    boolean createdirectory = false;
    private String Platform = null;

    public FormatMediaTasklet() {
        Trace.trace(TRACE_MASKT, "<> FormatMediaTasklet constructor");
    }

    public void service(PanelTaskletRequest taskletRequest, PanelTaskletResponse taskletResponse) throws TaskletException {
        block69: {
            Trace.trace(TRACE_MASKT, "-> FormatMedia.service()");
            if (taskletRequest.isInitialRequest()) {
                Trace.trace(TRACE_MASKF, "-> FormatMedia.isInitialRequest()");
                NetworkInfo NetworkInfo2 = new NetworkInfo();
                this.Platform = NetworkInfo2.getPlatform();
                Trace.trace(TRACE_MASKF, "Platform is : " + this.Platform);
                boolean dvd = true;
                boolean disk = true;
                boolean mem = true;
                String device = "DVD DRIVE";
                dvd = this.isLocalMediaAvailable(device);
                Trace.trace(TRACE_MASKF, "isLocalMediaAvailable DVD returned " + dvd);
                device = "DISKETTE DRIVE";
                disk = this.isLocalMediaAvailable(device);
                Trace.trace(TRACE_MASKF, "isLocalMediaAvailable diskette returned " + disk);
                device = "MEMORY STICK";
                mem = this.isLocalMediaAvailable(device);
                mem = true;
                Trace.trace(TRACE_MASKF, "isLocalMediaAvailable mem stick returned " + mem);
                MediaFormatBean bean = new MediaFormatBean(dvd, disk, mem);
                bean.setBeanName("MediaFormatBean");
                taskletResponse.openModalChild(AUIML_FILE_NAME, PANEL_NAME_INITIAL, bean);
                Trace.trace(TRACE_MASKF, "<- FormatMedia.isInitialRequest()");
            } else {
                Trace.trace(TRACE_MASKF, "taskletRequest.getData(event): " + taskletRequest.getData("event") + ".");
                Trace.trace(TRACE_MASKF, "taskletRequest.getData(radio_button): " + taskletRequest.getData("radiobutton") + ".");
                Trace.trace(TRACE_MASKF, "taskletRequest.getData(label): " + taskletRequest.getData(FormatMediaConstants.LABEL) + ".");
                if (taskletRequest.isDisposed() || taskletRequest.isCanceled()) {
                    Trace.trace(TRACE_MASKF, "taskletRequest.isDisposed() or isCanceled, issue taskletResponse.dispose().");
                    taskletResponse.dispose();
                } else {
                    Trace.trace(TRACE_MASKF, "Some taskletRequest other than Cancel is pending.");
                    String event = (String)taskletRequest.getData("event");
                    String label = (String)taskletRequest.getData(FormatMediaConstants.LABEL);
                    String radiobutton = (String)taskletRequest.getData("radiobutton");
                    boolean stop = false;
                    Trace.trace(TRACE_MASKF, "event is " + event);
                    Trace.trace(TRACE_MASKF, "radiobutton is " + radiobutton);
                    Trace.trace(TRACE_MASKF, "label is " + label);
                    if (event.equals("OkButton")) {
                        Trace.trace(TRACE_MASKF, "OK button found tasklet side.");
                        try {
                            Trace.trace(TRACE_MASKF, "radiobutton for ok_button equals " + radiobutton);
                            if (radiobutton.equals("DvdItem")) {
                                Trace.trace(TRACE_MASKF, "DVD radio button found tasklet side.");
                                FormatDvdCartridgeBean bean = new FormatDvdCartridgeBean(this.Platform);
                                bean.setBeanName("FormatDvdCartridgeBean");
                                taskletResponse.openModalChild(AUIML_FILE_NAME, PANEL_NAME_DVD, bean);
                                break block69;
                            }
                            if (radiobutton.equals("DisketteItem")) {
                                Trace.trace(TRACE_MASKF, "Diskette radio button found tasklet side.");
                                FormatDisketteBean bean = new FormatDisketteBean(this.Platform);
                                bean.setBeanName("FormatDisketteBean");
                                taskletResponse.openModalChild(AUIML_FILE_NAME, PANEL_NAME_DISKETTE, bean);
                                break block69;
                            }
                            if (!radiobutton.equals("MemoryKeyItem")) break block69;
                            Trace.trace(TRACE_MASKF, "MemoryKey radio button found tasklet side.");
                            boolean mem = false;
                            String device = "MEMORY STICK";
                            device = "MEMORY STICK";
                            mem = this.isLocalMediaAvailable(device);
                            Trace.trace(TRACE_MASKF, "isLocalMediaAvailable mem stick returned " + mem);
                            if (mem) {
                                FormatHighSpeedBean bean = new FormatHighSpeedBean();
                                bean.setBeanName("FormatHighSpeedBean");
                                taskletResponse.openModalChild(AUIML_FILE_NAME, PANEL_NAME_HIGHSPEED, bean);
                                break block69;
                            }
                            this.formatMediaMessages(12);
                            taskletResponse.noAction();
                        }
                        catch (Exception exc) {
                            HException hexc = new HException(exc);
                            new FrameworkLog(_logInfo, 12298, hexc).log();
                            Trace.trace(TRACE_MASKF, "Caught Exception in formatMediaMessages(int message)" + exc);
                        }
                    } else if (event.equals("DvdItem")) {
                        Trace.trace(TRACE_MASKF, "DVD event found tasklet side.");
                        Trace.trace(TRACE_MASKF, "radiobutton for DVD event equals " + radiobutton);
                        if (radiobutton.equals("ChangeLevelCartridgeRb")) {
                            Trace.trace(TRACE_MASKF, "Change level radio button found tasklet side.");
                            label = "ACTSUL";
                        } else if (radiobutton.equals("BackupRestoreCartridgeRb")) {
                            Trace.trace(TRACE_MASKF, "Backup restore radio button found tasklet side.");
                            label = "ACTBKP";
                        } else if (radiobutton.equals("ServiceDataCartridgeRb")) {
                            Trace.trace(TRACE_MASKF, "Service data radio button found tasklet side.");
                            label = "SRVDAT";
                        } else if (radiobutton.equals("SecurityLogCartridgeRb")) {
                            Trace.trace(TRACE_MASKF, "Security log data radio button found tasklet side.");
                            label = "ACTSECLG";
                        } else if (radiobutton.equals("VirtualRetainCartridgeRb")) {
                            Trace.trace(TRACE_MASKF, "Virtual Retain radio button found tasklet side.");
                            label = "VIRTRET";
                        } else if (radiobutton.equals("InputOutputCartridgeRb")) {
                            Trace.trace(TRACE_MASKF, "IOCDS radio button found tasklet side.");
                            label = "IOCDS";
                        } else {
                            Trace.trace(TRACE_MASKT, "I don't know this radio button: " + radiobutton + ".");
                        }
                        int lockDVD_error = 0;
                        boolean busy_msg_dvd = false;
                        try {
                            Trace.trace(TRACE_MASKF, "Mount the DVD read write");
                            lockDVD_error = this.mountMedia(2);
                            if (lockDVD_error == 0 || lockDVD_error == 8) {
                                Trace.trace(TRACE_MASKF, "DVD after mount media call lockDVD_error is " + lockDVD_error);
                                LocalizableText title = new LocalizableText(RES_BUNDLE_NAME, PANEL_TITLE);
                                LocalizableText msg = new LocalizableText(RES_BUNDLE_NAME, BUSY_MSG1);
                                this.showBusyDialog(title, msg);
                                busy_msg_dvd = true;
                                Trace.trace(TRACE_MASKF, "Busy dialog box created for DVD.");
                                Trace.trace(TRACE_MASKF, "Before calling format DVD");
                                Trace.trace(TRACE_MASKF, "label from screen is " + label);
                                this.formatDevice.format(label, 2);
                                Trace.trace(TRACE_MASKF, "Format DVD complete.");
                                Trace.trace(TRACE_MASKF, "Unlock the DVD device for second remount.");
                                this.formatDevice.unlock();
                                Trace.trace(TRACE_MASKF, "DVD device unlocked for second remount.");
                                lockDVD_error = this.mountMedia(2);
                                Trace.trace(TRACE_MASKF, "lockDVD_error on 2nd mount is " + lockDVD_error);
                                Trace.trace(TRACE_MASKF, "Unlock the DVD device.");
                                this.formatDevice.unlock();
                                Trace.trace(TRACE_MASKF, "DVD device unlocked.");
                                if (radiobutton.equals("ChangeLevelCartridgeRb")) {
                                    Trace.trace(TRACE_MASKF, "Change level DVD format. Create a directory mcl");
                                    this.createdirectory = true;
                                    Trace.trace(TRACE_MASKF, "Mount DVD and write directory.");
                                    lockDVD_error = this.mountMedia(2);
                                    Trace.trace(TRACE_MASKF, "Return from write. lockDVD_error is " + lockDVD_error);
                                    this.createdirectory = false;
                                    Trace.trace(TRACE_MASKF, "Unlock the DVD device.");
                                    this.formatDevice.unlock();
                                }
                            } else if (lockDVD_error == 9) {
                                Trace.trace(TRACE_MASKF, "Mount error DVD already unlocked ");
                            } else {
                                Trace.trace(TRACE_MASKF, "Mount error unlock DVD.");
                                this.formatDevice.unlock();
                                Trace.trace(TRACE_MASKF, "DVD device unlocked.");
                            }
                        }
                        catch (MediaDeviceException e) {
                            Trace.trace(TRACE_MASKT, "-> FormatMediaTaskletDVD.MediaDeviceException");
                            Trace.trace(TRACE_MASKT, "   Error message is : " + e.getMessage());
                            Trace.trace(TRACE_MASKF, "Check to see if DVD is locked");
                            if (lockDVD_error == 9) {
                                Trace.trace(TRACE_MASKF, "DVD is already unlocked ");
                            } else {
                                Trace.trace(TRACE_MASKF, "Unlock DVD.");
                                try {
                                    this.formatDevice.unlock();
                                    Trace.trace(TRACE_MASKF, "DVD device unlocked.");
                                }
                                catch (Exception e1) {
                                    Trace.trace(TRACE_MASKF, "Exception from unlock DVD in  FormatMediaTaskletDVD.MediaDeviceException");
                                }
                            }
                            lockDVD_error = 8;
                            new FrameworkLog(_logInfo, 12303, e).log(MicrocodeLogAttributes.INFO_LOG);
                            Trace.trace(TRACE_MASKT, "<- FormatMediaTaskletDVD.MediaDeviceException");
                        }
                        if (busy_msg_dvd) {
                            Trace.trace(TRACE_MASKF, "About to destroy busy dialog box DVD");
                            this.destroyBusyDialog();
                        }
                        if (lockDVD_error == 0) {
                            this.formatMediaMessages(6);
                            taskletResponse.terminate();
                        } else {
                            this.formatMediaMessages(lockDVD_error);
                            taskletResponse.noAction();
                        }
                    } else if (event.equals("DisketteItem")) {
                        Trace.trace(TRACE_MASKF, "Diskette event found tasklet side.");
                        Trace.trace(TRACE_MASKF, "radiobutton for diskette event equals " + radiobutton);
                        Trace.trace(TRACE_MASKF, "Label is : " + label);
                        if (radiobutton.equals("ChangeManagementItem")) {
                            Trace.trace(TRACE_MASKF, "Change level radio button found tasklet side.");
                            label = "ACTSUL";
                            Trace.trace(TRACE_MASKF, "Label is : " + label);
                        } else {
                            Trace.trace(TRACE_MASKF, "UserSpecified radio button found tasklet side.");
                            Trace.trace(TRACE_MASKF, "Label is : " + label);
                        }
                        int lockDiskette_error = 0;
                        boolean busy_msg_diskette = false;
                        Trace.trace(TRACE_MASKF, "Mount the diskette read write");
                        lockDiskette_error = this.mountMedia(1);
                        try {
                            if (lockDiskette_error == 0) {
                                Trace.trace(TRACE_MASKF, "Diskette mounted read write");
                                LocalizableText title = new LocalizableText(RES_BUNDLE_NAME, PANEL_TITLE);
                                LocalizableText msg = new LocalizableText(RES_BUNDLE_NAME, BUSY_MSG1);
                                this.showBusyDialog(title, msg);
                                busy_msg_diskette = true;
                                Trace.trace(TRACE_MASKF, "Busy dialog box created for diskette.");
                                Trace.trace(TRACE_MASKF, "Before calling format diskette");
                                this.formatDevice.format(label, 1);
                                Trace.trace(TRACE_MASKF, "Format diskette complete.");
                                Trace.trace(TRACE_MASKF, "Unlock the diskette device.");
                                this.formatDevice.unlock();
                                Trace.trace(TRACE_MASKF, "Diskette device unlocked.");
                                if (radiobutton.equals("ChangeManagementItem")) {
                                    Trace.trace(TRACE_MASKF, "Change level diskette format. Create a directory mcl");
                                    this.createdirectory = true;
                                    Trace.trace(TRACE_MASKF, "Mount diskette and write directory.");
                                    lockDiskette_error = this.mountMedia(1);
                                    Trace.trace(TRACE_MASKF, "Return from write. lockDiskette_error is " + lockDiskette_error);
                                    this.createdirectory = false;
                                    Trace.trace(TRACE_MASKF, "Unlock the diskette device.");
                                    this.formatDevice.unlock();
                                }
                            } else if (lockDiskette_error == 9) {
                                Trace.trace(TRACE_MASKF, "Mount error diskette already unlocked ");
                            } else {
                                Trace.trace(TRACE_MASKF, "Mount error unlock diskette.");
                                this.formatDevice.unlock();
                                Trace.trace(TRACE_MASKF, "Diskette device unlocked.");
                            }
                        }
                        catch (MediaDeviceException e) {
                            Trace.trace(TRACE_MASKT, "-> FormatMediaTaskletDiskette.MediaDeviceException");
                            Trace.trace(TRACE_MASKT, "   Error message is : " + e.getMessage());
                            Trace.trace(TRACE_MASKF, "Check to see if diskette is locked");
                            if (lockDiskette_error == 9) {
                                Trace.trace(TRACE_MASKF, "Diskette already unlocked ");
                            } else {
                                Trace.trace(TRACE_MASKF, "Unlock diskette.");
                                try {
                                    this.formatDevice.unlock();
                                    Trace.trace(TRACE_MASKF, "Diskette device unlocked.");
                                }
                                catch (Exception e1) {
                                    Trace.trace(TRACE_MASKF, "Exception from unlock diskette in  FormatMediaTaskletDiskette.MediaDeviceException");
                                }
                            }
                            lockDiskette_error = 7;
                            new FrameworkLog(_logInfo, 12304, e).log(MicrocodeLogAttributes.INFO_LOG);
                            Trace.trace(TRACE_MASKT, "<- FormatMediaTaskletDiskette.MediaDeviceException");
                        }
                        if (busy_msg_diskette) {
                            Trace.trace(TRACE_MASKF, "About to destroy busy dialog box diskette");
                            this.destroyBusyDialog();
                        }
                        if (lockDiskette_error == 0) {
                            this.formatMediaMessages(5);
                            taskletResponse.terminate();
                        } else {
                            this.formatMediaMessages(lockDiskette_error);
                            taskletResponse.noAction();
                        }
                    } else if (event.equals("MemoryKeyItem")) {
                        Trace.trace(TRACE_MASKF, "Memory Key event found tasklet side.");
                        Trace.trace(TRACE_MASKF, "Label is : " + label);
                        String device = "MEMORY STICK";
                        boolean mem = this.isLocalMediaAvailable(device);
                        int lockMem_error = 0;
                        boolean busy_msg_mem = false;
                        Trace.trace(TRACE_MASKF, "isLocalMediaAvailable mem stick returned " + mem);
                        if (mem) {
                            try {
                                Trace.trace(TRACE_MASKF, "Lock the High speed memory for use");
                                MediaServices msMedia = MediaServices.getMediaServices();
                                MediaDeviceIdentifier formatMediaId = msMedia.getPreferredDevice(8);
                                this.formatDevice = msMedia.requestLock(new LocalizableText("Media format"), formatMediaId);
                                LocalizableText title = new LocalizableText(RES_BUNDLE_NAME, PANEL_TITLE);
                                LocalizableText msg = new LocalizableText(RES_BUNDLE_NAME, BUSY_MSG1);
                                this.showBusyDialog(title, msg);
                                busy_msg_mem = true;
                                Trace.trace(TRACE_MASKF, "Busy dialog box created for Memory.");
                                Trace.trace(TRACE_MASKF, "Before calling format Memory");
                                Trace.trace(TRACE_MASKF, "label from screen is " + label);
                                this.formatDevice.format(label, 1);
                                Trace.trace(TRACE_MASKF, "Format High speed memory complete.");
                                Trace.trace(TRACE_MASKF, "Unlock the Memory device.");
                                this.formatDevice.unlock();
                                Trace.trace(TRACE_MASKF, "Memory device unlocked.");
                            }
                            catch (MediaDeviceLockException e) {
                                Trace.trace(TRACE_MASKT, "<-> FormatMedia.mountMedia.MediaDeviceLockException");
                                Trace.trace(TRACE_MASKT, "<-> Error message is : " + e.getMessage());
                                lockMem_error = 9;
                            }
                            catch (MediaDeviceException e) {
                                Trace.trace(TRACE_MASKT, "-> FormatMediaTaskletMEM.MediaDeviceException");
                                Trace.trace(TRACE_MASKT, "   Error message is : " + e.getMessage());
                                Trace.trace(TRACE_MASKF, "Unlock Memory.");
                                try {
                                    this.formatDevice.unlock();
                                    Trace.trace(TRACE_MASKF, "Memory device unlocked.");
                                }
                                catch (Exception e1) {
                                    Trace.trace(TRACE_MASKF, "Exception from unlock Memory in  FormatMediaTaskletMEM.MediaDeviceException");
                                }
                                lockMem_error = 11;
                                new FrameworkLog(_logInfo, 12309, e).log(MicrocodeLogAttributes.INFO_LOG);
                                Trace.trace(TRACE_MASKT, "<- FormatMediaTaskletMEM.MediaDeviceException");
                            }
                            if (busy_msg_mem) {
                                Trace.trace(TRACE_MASKF, "About to destroy busy dialog box Memory");
                                this.destroyBusyDialog();
                            }
                        } else {
                            Trace.trace(TRACE_MASKF, "High speed memory not installed");
                            lockMem_error = 12;
                        }
                        if (lockMem_error == 0) {
                            this.formatMediaMessages(10);
                            taskletResponse.terminate();
                        } else {
                            this.formatMediaMessages(lockMem_error);
                            taskletResponse.noAction();
                        }
                    } else {
                        Trace.trace(TRACE_MASKT, "Unknown tasklet request sent to the FormatMedia.");
                    }
                }
            }
        }
        Trace.trace(TRACE_MASKT, "<- FormatMedia.service()");
    }

    public void formatMediaMessages(int message) {
        Trace.trace(TRACE_MASKT, "-> FormatMedia.formatMediaMessages(int message)");
        int choice = message;
        MessageText[] text = new BaseMessageText[1];
        BaseMessageTitle title = null;
        Object msgId = null;
        try {
            switch (choice) {
                case 1: {
                    Trace.trace(TRACE_MASKF, "Do setup for diskette not ready Panel");
                    title = new BaseMessageTitle("DVD80005");
                    text[0] = new BaseMessageText("DVD00001E");
                    Trace.trace(TRACE_MASKF, "Setup complete for diskette not ready Panel");
                    break;
                }
                case 2: {
                    Trace.trace(TRACE_MASKF, "Do setup for DVD not ready panel");
                    title = new BaseMessageTitle("DVD80003");
                    text[0] = new BaseMessageText("DVD00002E");
                    Trace.trace(TRACE_MASKF, "Setup complete for DVD not ready panel");
                    break;
                }
                case 3: {
                    Trace.trace(TRACE_MASKF, "Do setup for diskette write protected panel");
                    title = new BaseMessageTitle("DVD80006");
                    text[0] = new BaseMessageText("DVD00003E");
                    Trace.trace(TRACE_MASKF, "Setup complete for diskette write protected panel");
                    break;
                }
                case 4: {
                    Trace.trace(TRACE_MASKF, "Do setup for DVD write protected panel");
                    title = new BaseMessageTitle("DVD80004");
                    text[0] = new BaseMessageText("DVD00004E");
                    Trace.trace(TRACE_MASKF, "Setup complete for DVD write protected panel");
                    break;
                }
                case 5: {
                    Trace.trace(TRACE_MASKF, "Do setup for Format diskette successful Panel");
                    title = new BaseMessageTitle("DVD80001");
                    text[0] = new BaseMessageText("DVD00005I");
                    Trace.trace(TRACE_MASKF, "Setup complete for Format diskette successful Panel");
                    break;
                }
                case 6: {
                    Trace.trace(TRACE_MASKF, "Do setup for Format DVD successful panel");
                    title = new BaseMessageTitle("DVD80001");
                    text[0] = new BaseMessageText("DVD00006I");
                    Trace.trace(TRACE_MASKF, "Setup complete for Format DVD successful panel");
                    break;
                }
                case 7: {
                    Trace.trace(TRACE_MASKF, "Do setup for format diskette error panel");
                    title = new BaseMessageTitle("DVD80002");
                    text[0] = new BaseMessageText("DVD00007E");
                    Trace.trace(TRACE_MASKF, "Setup complete for format diskette error panel");
                    break;
                }
                case 8: {
                    Trace.trace(TRACE_MASKF, "Do setup for format DVD error panel");
                    title = new BaseMessageTitle("DVD80002");
                    text[0] = new BaseMessageText("DVD00008E");
                    Trace.trace(TRACE_MASKF, "Setup complete for format DVD error panel");
                    break;
                }
                case 9: {
                    Trace.trace(TRACE_MASKF, "Do setup for media device in use panel");
                    title = new BaseMessageTitle(PANEL_TITLE);
                    text[0] = new BaseMessageText("DVD00009I");
                    Trace.trace(TRACE_MASKF, "Setup complete for media device in use panel");
                    break;
                }
                case 10: {
                    Trace.trace(TRACE_MASKF, "Do setup for Format Mem Key successful panel");
                    title = new BaseMessageTitle("DVD80001");
                    text[0] = new BaseMessageText("DVD00010I");
                    Trace.trace(TRACE_MASKF, "Setup complete for Format Mem Key successful panel");
                    break;
                }
                case 11: {
                    Trace.trace(TRACE_MASKF, "Do setup for format Mem Key error panel");
                    title = new BaseMessageTitle("DVD80002");
                    text[0] = new BaseMessageText("DVD00011E");
                    Trace.trace(TRACE_MASKF, "Setup complete for format Mem Key error panel");
                    break;
                }
                case 12: {
                    Trace.trace(TRACE_MASKF, "Do setup for Memory not inserted Panel");
                    title = new BaseMessageTitle("DVD80009");
                    text[0] = new BaseMessageText("DVD00012E");
                    Trace.trace(TRACE_MASKF, "Setup complete for Memory not inserted Panel");
                    break;
                }
                default: {
                    HException hexc = new HException("Unknown error");
                    Trace.trace(TRACE_MASKF, hexc);
                    Trace.trace(TRACE_MASKF, "Return code from Server does not match message box case number." + hexc);
                    new FrameworkLog(_logInfo, 12300, hexc).log();
                    break;
                }
            }
            Trace.trace(TRACE_MASKF, "message to be displayed is : " + text[0].toString());
            this.showMessageBox(true, title, text, null, null, null);
        }
        catch (Exception exc) {
            HException hexc = new HException(exc);
            Trace.trace(TRACE_MASKF, "Caught Excecption in formatMediaMessages(int message)" + exc);
            new FrameworkLog(_logInfo, 12301, hexc).log();
        }
        Trace.trace(TRACE_MASKT, "<- FormatMedia.formatMediaMessages(int message)");
    }

    public void logException(Throwable throwable) {
        Trace.trace(TRACE_MASKT, "-> FormatMedia.logException()");
        Trace.trace(TRACE_MASKT, "processing exception: " + throwable);
        HException hexc = new HException(throwable);
        new FrameworkLog(_logInfo, 12299, hexc).log();
        Trace.trace(TRACE_MASKT, "<- FormatMedia.logException()");
    }

    public int mountMedia(int device) {
        int mountMedia_error = 0;
        String mount_media = null;
        Trace.trace(TRACE_MASKT, "-> FormatMedia.mountMedia()");
        Trace.trace(TRACE_MASKF, "mount_media is = " + mount_media);
        try {
            Trace.trace(TRACE_MASKF, "Before creating class mediaServices");
            MediaServices msMedia = MediaServices.getMediaServices();
            Trace.trace(TRACE_MASKF, "After creating class mediaServices");
            MediaDeviceIdentifier formatMediaId = device == 2 ? msMedia.getPreferredDevice(6) : msMedia.getPreferredDevice(1);
            this.formatDevice = msMedia.requestLock(new LocalizableText("Media format"), formatMediaId);
            Trace.trace(TRACE_MASKF, "Mount Media read write");
            this.formatDevice.mountReadWrite();
            Trace.trace(TRACE_MASKF, "Media mounted read write");
            if (this.createdirectory) {
                String directoryPath = this.formatDevice.getMountPoint().getAbsolutePath() + "/mcl/";
                Trace.trace(TRACE_MASKF, "create directory value is true");
                Trace.trace(TRACE_MASKF, "directoryPath is : " + directoryPath);
                File f1diskette = new File(directoryPath);
                f1diskette.mkdirs();
                Trace.trace(TRACE_MASKF, "directory created");
                this.createdirectory = false;
            }
            Trace.trace(TRACE_MASKF, "Unmount Media");
            this.formatDevice.unmount();
            Trace.trace(TRACE_MASKF, "Media unmounted");
        }
        catch (IllegalArgumentException e) {
            Trace.trace(TRACE_MASKT, "<-> FormatMedia.mountMedia.IllegalArgumentException");
            Trace.trace(TRACE_MASKT, "<-> Error message is : " + e.getMessage());
            mountMedia_error = device == 2 ? 8 : 7;
            new FrameworkLog(_logInfo, 12302, e).log();
        }
        catch (MediaDeviceLockException e) {
            Trace.trace(TRACE_MASKT, "<-> FormatMedia.mountMedia.MediaDeviceLockException");
            Trace.trace(TRACE_MASKT, "<-> Error message is : " + e.getMessage());
            mountMedia_error = 9;
        }
        catch (MediaWriteProtectedException e) {
            Trace.trace(TRACE_MASKT, "<-> FormatMedia.mountMedia.MediaWriteProtectedException");
            Trace.trace(TRACE_MASKT, "<-> Error message is : " + e.getMessage());
            mountMedia_error = device == 2 ? 4 : 3;
        }
        catch (NoMediaPresentException e) {
            Trace.trace(TRACE_MASKT, "<-> FormatMedia.mountMedia.NoMediaPresentException");
            Trace.trace(TRACE_MASKT, "<-> Error message is : " + e.getMessage());
            mountMedia_error = device == 2 ? 2 : 1;
        }
        catch (MediaDeviceException e) {
            Trace.trace(TRACE_MASKT, "<-> FormatMedia.mountMedia.MediaDeviceException");
            Trace.trace(TRACE_MASKT, "<-> Error message is : " + e.getMessage());
            mountMedia_error = device == 2 ? 8 : 7;
            new FrameworkLog(_logInfo, 12305, e).log();
        }
        catch (Exception e) {
            Trace.trace(TRACE_MASKT, "<-> FormatMedia.mountMedia.Exception");
            Trace.trace(TRACE_MASKT, "<-> Error message is : " + e.getMessage());
            mountMedia_error = device == 2 ? 8 : 7;
            new FrameworkLog(_logInfo, 12306, e).log();
        }
        Trace.trace(TRACE_MASKT, "<- FormatMedia.mountMedia()");
        return mountMedia_error;
    }

    private boolean isLocalMediaAvailable(String media) {
        MediaDeviceIdentifier local_media_device = null;
        Trace.trace(TRACE_MASKT, "-> FormatMedia.isLocalMediaAvailable(media)");
        Trace.trace(TRACE_MASKT, "media is " + media);
        boolean flag = false;
        MediaServicesUtil msu = new MediaServicesUtil(this);
        MediaServices ms = null;
        try {
            ms = MediaServices.getMediaServices();
            if (media.equals("DISKETTE DRIVE")) {
                MediaDeviceIdentifier[] mdis = ms.getMediaDeviceIdentifiers(1);
                if (mdis != null && mdis.length != 0) {
                    local_media_device = mdis[0];
                    flag = true;
                }
            } else if (media.equals("DVD DRIVE")) {
                MediaDeviceIdentifier[] mdis = ms.getMediaDeviceIdentifiers(3);
                if (mdis != null && mdis.length != 0) {
                    local_media_device = mdis[0];
                    flag = true;
                }
            } else {
                MediaDeviceIdentifier[] mdis = ms.getMediaDeviceIdentifiers(8);
                if (mdis != null && mdis.length != 0) {
                    local_media_device = mdis[0];
                    flag = true;
                }
            }
        }
        catch (MediaDeviceException mde) {
            Trace.trace(TRACE_MASKF, "  exception getting MediaServices = " + mde);
            if (ms == null) {
                Trace.trace(TRACE_MASKF, "--  Media Services is null?");
                new FrameworkLog(_logInfo, 12307, mde).log();
            } else {
                new FrameworkLog(_logInfo, 12308, mde).log();
            }
            Trace.trace(TRACE_MASKF, "--  exception getting MediaServices = " + mde + "\nMessage: " + mde.getMessage());
            flag = false;
        }
        if (local_media_device != null) {
            Trace.trace(TRACE_MASKF, "  local media device type = " + local_media_device.getDeviceType());
            Trace.trace(TRACE_MASKF, "    Name = " + local_media_device.getDisplayableDeviceName());
            Trace.trace(TRACE_MASKF, "    Description = " + local_media_device.getDisplayableDeviceDescription());
        }
        Trace.trace(TRACE_MASKT, "<- FormatMedia.isLocalMediaAvailable(media) == " + flag);
        return flag;
    }
}

